% main_estimation_mode.m
% 
% main mode finding algorithm
% 
% Estimating Macroeconomic Models of Financial Crises: An Endogenous Regime-Switching Approach*
%   Gianluca Benigno, Andrew Foerster, Christopher Otrok, Alessandro Rebucci
% 
% Updated July 2024
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %



% -- Clear Workspace -- %
clc;
clear;
close all;


% -- Options -- %
addpath('../Solver - SV');          % add path with solution code 
addpath('../Data');                 % add path with data
addpath(genpath('../Utilities'));    
GLOBALS = globals();                % load structure of GLOBALS

% -- Filtering Type -- %
kf_filtering_level = 0;
% if 0, the updated variables are required
% If 1, the smoothed variables are required

% -- Set System Dimensions -- %
ny = GLOBALS.ny;   % # of control variables
nx = GLOBALS.nx;   % # of state variables
ne = GLOBALS.ne;   % # of structural shocks
ns = GLOBALS.ns;   % # of regimes

% -- Set Estimation Dimensions -- %
NX = GLOBALS.estimation.NX;   % # of states in estimation

% -- Set Observables in Estimation -- %
y = GLOBALS.y;

% -- Load Initial Thetas -- %
THETA   = getparams(GLOBALS);

% -- Paramter Transform -- %
THETA   = param_transform(THETA,GLOBALS,1);
    
% -- Minimizer -- %
[MinFuncValue,post_mode] =...
    csminwel('endo_ms_lik_2nd_kim_nelson_transform_SV',THETA,...
    eye(length(THETA)),[],1e-3,1,...
    y,kf_filtering_level,1,1,GLOBALS); 

% -- Output -- %
newtheta  = param_transform(post_mode,GLOBALS,-1);
posterior  = endo_ms_lik_2nd_kim_nelson_SV(newtheta,y,kf_filtering_level,1,1,GLOBALS);  

